clear all; clc;

rng(100);

currentPath = pwd;  % 获取当前路径
parentPath = fileparts(currentPath);  % 获取上一级路径
addpath(parentPath);  % 添加上一级路径

f_c = 3.5e9;        % Frequency

load('Kernal.mat');

h = CDL_channel(x,f_c);
h = h/sqrt(mean(diag(Kernal_CDL_mean)));

sigma2_dB = -20;                % Noise power dB
sigma2 = 10.^(sigma2_dB/10);    % Noise power
P = 4;                          % Number of pilots
N_ports = 4;                    % Number of RF chains

[h_hat_GPR,cor,index_A,h_o] = GPR_multi(x,h,Kernal_CDL_mean,sigma2,P*N_ports,1);

NMSE_GPR = mag2db(norm(h_hat_GPR - h)/norm(h))

Plotfigure_2;



